"""mysite URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/4.1/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path, include
from django.conf import settings
from django.conf.urls.static import static
from . import views

urlpatterns = [
    path("", views.index, name="index"),
    path('admin/', admin.site.urls),
    path("center/", include("center.urls", namespace="center")),
    path("vaccine/", include("vaccine.urls", namespace="vaccine")),
    path("accounts/", include("user.urls", namespace="accounts")),
    path("campaign/", include("campaign.urls", namespace="campaign")),
    path("vaccination/", include("vaccination.urls", namespace="vaccination")),
]

# Static Files Configuration
urlpatterns += static(settings.STATIC_URL,
                      document_root=settings.STATIC_ROOT)

# Media Files Configurations
urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
